<?php
require_once "config.php";
?>
<!DOCTYPE html>
<html lang="tr">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="description" content="<?=$description?>">
      <meta name="author" content="Arena Sports">
      <title><?=$title?></title>
      <!-- Favicon Icon -->
      <link rel="icon" type="image/png" href="<?=$favicon?>">
      <!-- Bootstrap core CSS-->
      <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
      <!-- Custom fonts -->
      <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
      <!-- Custom styles -->
      <link href="css/style.css" rel="stylesheet">
      <!-- Owl Carousel -->
      <link rel="stylesheet" href="vendor/owl-carousel/owl.carousel.css">
      <link rel="stylesheet" href="vendor/owl-carousel/owl.theme.css">
      <style>
        .login-main-wrapper {
            background: url('<?=$backgroundImage?>') no-repeat center center fixed;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
        }
        .login-main-wrapper::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(20, 27, 36, 0.85);
        }
        .login-box {
            background: var(--bg-dark);
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.5);
            position: relative;
            max-width: 500px;
            margin: 0 auto;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .login-logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .login-logo img {
            max-width: 200px;
            height: auto;
        }
        .welcome-text {
            text-align: center;
            margin-bottom: 30px;
        }
        .welcome-text h4 {
            color: #fff;
            font-weight: 600;
            margin-bottom: 15px;
        }
        .welcome-text p {
            color: rgba(255, 255, 255, 0.8);
            font-size: 16px;
            line-height: 1.6;
        }
        .redirect-text {
            text-align: center;
            margin-top: 30px;
            color: rgba(255, 255, 255, 0.6);
            font-size: 14px;
        }
        .loading-spinner {
            width: 40px;
            height: 40px;
            margin: 20px auto;
            border: 4px solid rgba(255, 255, 255, 0.1);
            border-top: 4px solid #00ffff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        :root {
            --bg-dark: #141b24;
            --primary-color: #00ffff;
            --secondary-color: #ff4757;
        }
      </style>
   </head>
   <body>
      <div class="login-main-wrapper">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-md-8">
                  <div class="login-box">
                     <div class="login-logo">
                        <img src="<?=$navLogo?>" alt="<?=$navLogoAlt?>" class="img-fluid">
                     </div>
                     <div class="welcome-text">
                        <h4>Arena Sports'a Hoş Geldiniz</h4>
                        <p>Canlı maç yayınlarını HD kalitede izlemek için hazırlanıyor...</p>
                     </div>
                     <form id="autoSubmitForm" method="post" action="watch.php">
                        <input type="hidden" name="iptv" id="iptv" value="<?=htmlspecialchars($playlistUrl)?>">
                     </form>
                     <div class="loading-spinner"></div>
                     <div class="redirect-text">
                        <p>5 saniye içinde yönlendiriliyorsunuz...</p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <!-- Bootstrap core JavaScript-->
      <script src="vendor/jquery/jquery.min.js"></script>
      <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
      <!-- Core plugin JavaScript-->
      <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
      <!-- Owl Carousel -->
      <script src="vendor/owl-carousel/owl.carousel.js"></script>
      <!-- Custom scripts -->
      <script src="js/main.js"></script>
      <script>
         document.addEventListener('DOMContentLoaded', function() {
             setTimeout(function() {
                 try {
                     var form = document.getElementById("autoSubmitForm");
                     if(form) {
                         form.submit();
                     }
                 } catch(e) {
                     console.error("Form gönderme hatası:", e);
                 }
             }, 5000);
         });
      </script>
   </body>
</html>
