document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.querySelector('.kanal-arama');
    const channelItems = document.querySelectorAll('.nav-item');

    // İlk kanalı otomatik seç
    const firstChannel = document.querySelector('.channel');
    if(firstChannel) {
        firstChannel.click();
    }

    // Arama debounce ekle
    let searchTimeout;
    searchInput.addEventListener('input', function(e) {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            const searchTerm = e.target.value.toLowerCase();
            channelItems.forEach(item => {
                const channelName = item.querySelector('.nav-link').textContent.toLowerCase();
                item.style.display = channelName.includes(searchTerm) ? '' : 'none';
            });
        }, 300);
    });

    // Aktif kanal seçimi
    const channels = document.querySelectorAll('.channel');
    channels.forEach(channel => {
        channel.addEventListener('click', function() {
            // Önceki aktif kanalın stilini kaldır
            document.querySelector('.channel.active')?.classList.remove('active');
            // Tıklanan kanala aktif stilini ekle
            this.classList.add('active');
            
            // Player kaynağını güncelle
            player.configure({
                source: this.getAttribute('data-value')
            });
        });
    });
}); 